/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import okhttp3.Headers;

public class TelemetryAnswer<TYPE> {
    public final long original;
    public final long current;
    @Nullable
    public Date date;
    @NonNull
    public TYPE holder;

    public TelemetryAnswer(long original, @Nullable Headers headers, @NonNull TYPE holder) {
        this.original = original;
        this.current = System.currentTimeMillis();
        this.date = null;
        if (null != headers) {
            for (String name : headers.names()) {
                if (!"date".equalsIgnoreCase(name)) continue;
                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    this.date = dateFormat.parse(headers.get(name));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        this.holder = holder;
    }

    public String toString() {
        return "TelemetryAnswer{original=" + this.original + ", current=" + this.current + ", date=" + this.date + ", holder=" + this.holder + '}';
    }
}

