/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.builders;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.push.utils.NoDocumentation;
import com.voxeet.sdk.services.conference.information.ConferenceParticipantType;
import com.voxeet.sdk.utils.Annotate;

@Annotate
public class ConferenceJoinOptions {
    private String conferenceId;
    private ParamsHolder paramsHolder;
    private ConferenceParticipantType conferenceParticipantType;

    private ConferenceJoinOptions() {
    }

    @Nullable
    public String getConferenceId() {
        return this.conferenceId;
    }

    @Nullable
    public ParamsHolder getParamsHolder() {
        return this.paramsHolder;
    }

    @NonNull
    public ConferenceParticipantType getConferenceParticipantType() {
        return this.conferenceParticipantType;
    }

    @Annotate
    public static class Builder {
        private ConferenceJoinOptions options = new ConferenceJoinOptions();

        private Builder() {
        }

        @Deprecated
        @NoDocumentation
        public Builder(@NonNull String conferenceId) {
            this();
            this.options.conferenceId = conferenceId;
        }

        public Builder(@NonNull Conference conference) {
            this();
            this.options.conferenceId = conference.getId();
        }

        public Builder setParamsHolder(@Nullable ParamsHolder paramsHolder) {
            this.options.paramsHolder = paramsHolder;
            return this;
        }

        public Builder setConferenceParticipantType(@NonNull ConferenceParticipantType conferenceParticipantType) {
            this.options.conferenceParticipantType = conferenceParticipantType;
            return this;
        }

        @NonNull
        public ConferenceJoinOptions build() {
            return this.options;
        }
    }
}

