/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import com.voxeet.VoxeetSDK;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiSubscribe;
import com.voxeet.sdk.push.center.NotificationCenter;
import com.voxeet.sdk.push.center.SubscriptionCenter;
import com.voxeet.sdk.push.center.subscription.register.BaseSubscription;
import com.voxeet.sdk.push.center.subscription.register.SubscribeInvitation;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.authenticate.WebSocketState;
import com.voxeet.sdk.services.notification.events.ConferenceStatusNotificationEvent;
import com.voxeet.sdk.services.notification.internal.WebSocketConferenceCreated;
import com.voxeet.sdk.services.notification.internal.WebSocketConferenceEnded;
import com.voxeet.sdk.services.notification.internal.WebSocketParticipantJoined;
import com.voxeet.sdk.services.notification.internal.WebSocketParticipantLeft;
import com.voxeet.sdk.services.notification.internal.WebsocketConferenceStatusNotificationEvent;
import com.voxeet.sdk.utils.Callback;
import com.voxeet.sdk.utils.Getter;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Map;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Call;

@Annotate
public class NotificationService
extends AbstractVoxeetService {
    private Events events = new Events();
    public final NotificationCenter center = NotificationCenter.instance;
    final SubscriptionCenter subscription = SubscriptionCenter.instance;

    @NoDocumentation
    public NotificationService(@NonNull SdkEnvironmentHolder instance) {
        super(instance);
        NotificationCenter.instance.init(instance.voxeetSdk.getEventBus(), instance.voxeetSdk.getApplicationContext());
        instance.voxeetSdk.register(this.events);
    }

    public Promise<Boolean> subscribe(BaseSubscription ... subscriptions) {
        return this.subscribe(new ArrayList<BaseSubscription>(Arrays.asList(subscriptions)));
    }

    public Promise<Boolean> subscribe(@NonNull List<BaseSubscription> subscriptions) {
        return this.apply(subscriptions, (Callback<BaseSubscription>)((Callback)arg_0 -> ((SubscriptionCenter)SubscriptionCenter.instance).subscribe(arg_0)), (Getter<Call<ResponseBody>>)((Getter)() -> this.getService(IRestApiSubscribe.class).subscribe(new IRestApiSubscribe.Subscriptions(subscriptions))), ServerErrorOrigin.SUBSCRIBE);
    }

    public Promise<Boolean> unsubscribe(BaseSubscription ... subscriptions) {
        return this.unsubscribe(new ArrayList<BaseSubscription>(Arrays.asList(subscriptions)));
    }

    public Promise<Boolean> unsubscribe(@NonNull List<BaseSubscription> subscriptions) {
        return this.apply(subscriptions, (Callback<BaseSubscription>)((Callback)arg_0 -> ((SubscriptionCenter)SubscriptionCenter.instance).unsubscribe(arg_0)), (Getter<Call<ResponseBody>>)((Getter)() -> this.getService(IRestApiSubscribe.class).unsubscribe(new IRestApiSubscribe.Subscriptions(subscriptions))), ServerErrorOrigin.UNSUBSCRIBE);
    }

    private Promise<Boolean> apply(@NonNull List<BaseSubscription> list, @NonNull Callback<BaseSubscription> centerApply, @NonNull Getter<Call<ResponseBody>> endpoint, @NonNull ServerErrorOrigin origin) {
        boolean needNetworkCall;
        if ((Integer)Opt.of(list).then(List::size).or((Object)0) == 0) {
            return Promise.reject((Throwable)new IllegalStateException("Need to have subscribable object"));
        }
        boolean bl = needNetworkCall = Map.find(list, iSubscribe -> (Boolean)Opt.of((Object)iSubscribe).then(BaseSubscription::isNetworkCall).or((Object)false)) != null;
        if (!needNetworkCall) {
            Map.safeApply(list, centerApply);
            return Promise.resolve((Object)true);
        }
        return new Promise(solver -> {
            Call call = (Call)endpoint.get();
            HttpHelper.promise(call, origin).then(result -> {
                Map.safeApply((List)list, (Callback)centerApply);
                solver.resolve((Object)true);
            }).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }

    @Deprecated
    @NoDocumentation
    @NonNull
    public Promise<List<Participant>> invite(@NonNull String conferenceId, @NonNull List<ParticipantInfo> participantOptions) {
        return VoxeetSDK.conference().invite(conferenceId, participantOptions);
    }

    private class Events {
        private Events() {
        }

        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull SocketStateChangeEvent event) {
            if (WebSocketState.CONNECTED.equals((Object)event.state)) {
                NotificationService.this.subscribe(new BaseSubscription[]{new SubscribeInvitation()}).execute();
            }
        }

        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull WebSocketConferenceCreated event) {
            NotificationService.this.subscription.onEvent(event.to());
        }

        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull WebSocketConferenceEnded event) {
            NotificationService.this.subscription.onEvent(event.to());
        }

        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull WebSocketParticipantJoined event) {
            NotificationService.this.subscription.onEvent(event.to());
        }

        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull WebSocketParticipantLeft event) {
            NotificationService.this.subscription.onEvent(event.to());
        }

        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull WebsocketConferenceStatusNotificationEvent event) {
            NotificationService.this.getEventBus().post((Object)new ConferenceStatusNotificationEvent(event.conferenceId, event.conferenceAlias, event.isLive, event.startTimestamp, event.asParticipants()));
        }
    }
}

