/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.v2;

import android.support.annotation.Nullable;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.HashMap;

@Annotate
public enum ChatMessageType {
    TEXT("text");

    private static boolean init;
    private static HashMap<String, ChatMessageType> map;
    private static ChatMessageType[] VALUES;
    private final String text;

    @NoDocumentation
    private ChatMessageType(String text) {
        this.text = text;
    }

    @NoDocumentation
    public static ChatMessageType fromString(String text) {
        ChatMessageType.checkInit();
        return map.get(text);
    }

    private static void checkInit() {
        if (!init) {
            for (ChatMessageType type : VALUES) {
                map.put(type.text, type);
            }
            init = true;
        }
    }

    @Nullable
    public String text() {
        return this.text;
    }

    static {
        init = false;
        map = new HashMap();
        VALUES = new ChatMessageType[]{TEXT};
    }
}

