/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.RestParticipant;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.models.v2.ParticipantMediaStreamHandler;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@Annotate
public class Participant {
    @NonNull
    private ParticipantMediaStreamHandler streamsHandler;
    @NonNull
    private CopyOnWriteArrayList<MediaStream> streams = new CopyOnWriteArrayList();
    @Nullable
    private String id;
    @Nullable
    private ParticipantInfo participantInfo;
    @NonNull
    private ConferenceParticipantStatus status;
    private String quality;

    private Participant() {
        this.streamsHandler = new ParticipantMediaStreamHandler(this);
    }

    @NoDocumentation
    public Participant(@Nullable String id, @Nullable ParticipantInfo participantInfo) {
        this();
        this.id = id;
        this.participantInfo = participantInfo;
    }

    @NoDocumentation
    public Participant(@NonNull ConferenceUser conferenceUser) {
        this(conferenceUser.getUserId(), conferenceUser.getParticipantInfo());
        this.updateStatus(conferenceUser.getConferenceStatus());
    }

    @NoDocumentation
    public Participant(@Nullable ParticipantInfo participantInfo) {
        this(null, participantInfo);
    }

    @NoDocumentation
    public Participant(@NonNull RestParticipant participant) {
        this(participant.getParticipantId(), new ParticipantInfo(participant.getName(), participant.getExternalId(), participant.getAvatarUrl()));
    }

    @NoDocumentation
    public Participant(@NonNull SdkParticipant participant) {
        this(participant.getUserId(), new ParticipantInfo(participant.getMetadata().getExternalName(), participant.getMetadata().getExternalId(), participant.getMetadata().getExternalPhotoUrl()));
        this.updateStatus(ConferenceParticipantStatus.valueOf((String)participant.getStatus()));
    }

    public boolean isLocallyActive() {
        return ConferenceParticipantStatus.ON_AIR.equals((Object)this.getStatus()) || ConferenceParticipantStatus.CONNECTING.equals((Object)this.getStatus()) && this.streams().size() > 0;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public ParticipantInfo getInfo() {
        return this.participantInfo;
    }

    @NonNull
    public List<MediaStream> streams() {
        return this.streams;
    }

    @NonNull
    public ParticipantMediaStreamHandler streamsHandler() {
        return this.streamsHandler;
    }

    @NoDocumentation
    @NonNull
    public Participant updateStatus(@NonNull ConferenceParticipantStatus status) {
        this.status = status;
        return this;
    }

    @NonNull
    public ConferenceParticipantStatus getStatus() {
        return this.status;
    }

    @NoDocumentation
    public boolean equals(@Nullable Object obj) {
        String externalId;
        Object participant;
        if (null == this.id && null == this.participantInfo) {
            return false;
        }
        boolean same = false;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConferenceUser) {
            String externalId2;
            ConferenceUser conferenceUser = (ConferenceUser)obj;
            ParticipantInfo conferenceParticipantInfo = conferenceUser.getParticipantInfo();
            String string = externalId2 = null != this.participantInfo ? this.participantInfo.getExternalId() : null;
            if (null != this.id) {
                same |= this.id.equals(conferenceUser.getUserId());
            }
            if (null != externalId2 && null != conferenceParticipantInfo) {
                same |= externalId2.equals(conferenceParticipantInfo.getExternalId());
            }
        }
        if (obj instanceof RestParticipant) {
            participant = (RestParticipant)obj;
            String string = externalId = null != this.participantInfo ? this.participantInfo.getExternalId() : null;
            if (null != this.id) {
                same |= this.id.equals(((RestParticipant)participant).getParticipantId());
            }
            if (null != this.id && null != externalId) {
                same |= externalId.equals(((RestParticipant)participant).getExternalId());
            }
        }
        if (obj instanceof Participant) {
            participant = (Participant)obj;
            externalId = null != this.participantInfo ? this.participantInfo.getExternalId() : null;
            ParticipantInfo other = ((Participant)participant).getInfo();
            if (null != this.id) {
                same |= this.id.equals(((Participant)participant).getId());
            }
            if (null != this.id && null != externalId && null != other) {
                same |= externalId.equals(other.getExternalId());
            }
        }
        return same;
    }

    @NoDocumentation
    public Participant setParticipantInfo(@NonNull ParticipantInfo participantInfo) {
        this.participantInfo = participantInfo;
        return this;
    }

    @Deprecated
    @NoDocumentation
    public void setQuality(@NonNull String quality) {
        this.quality = quality;
    }

    @NoDocumentation
    public void updateIfNeeded(@Nullable String name, @Nullable String avatarUrl) {
        if (null == this.participantInfo) {
            this.participantInfo = new ParticipantInfo();
        }
        if (!(null == name || null != this.participantInfo.getName() && name.equals(this.participantInfo.getName()))) {
            this.participantInfo.setName(name);
        }
        if (null != avatarUrl && (null == this.participantInfo.getAvatarUrl() || avatarUrl.equals(this.participantInfo.getAvatarUrl()))) {
            this.participantInfo.setAvatarUrl(avatarUrl);
        }
    }

    @NoDocumentation
    @NonNull
    public String toString() {
        return "Participant{id='" + this.id + '\'' + ", participantInfo=" + this.participantInfo + ", status=" + this.status + ", quality='" + this.quality + '\'' + '}';
    }

    @NoDocumentation
    public Map<String, String> asMap() {
        HashMap<String, String> infos = new HashMap<String, String>();
        infos.put("UserId", (String)Opt.of((Object)this.getId()).or((Object)""));
        infos.put("DisplayName", (String)Opt.of((Object)this.getInfo()).then(ParticipantInfo::getName).or((Object)""));
        infos.put("ExternalId", (String)Opt.of((Object)this.getInfo()).then(ParticipantInfo::getExternalId).or((Object)""));
        infos.put("AvatarUrl", (String)Opt.of((Object)this.getInfo()).then(ParticipantInfo::getAvatarUrl).or((Object)""));
        return infos;
    }
}

