/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.VoxeetSDK;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiTelemetry;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.telemetry.TelemetryAnswer;
import com.voxeet.sdk.telemetry.WebRTCStats;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class WebRTCStatsPromise
extends AbstractPromiseable<TelemetryAnswer<Boolean>, IRestApiTelemetry> {
    private final WebRTCStats webRtcStats;

    public WebRTCStatsPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiTelemetry provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull WebRTCStats webRtcStats) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.webRtcStats = webRtcStats;
    }

    @Override
    @NonNull
    public Promise<TelemetryAnswer<Boolean>> createPromise() {
        return new Promise(solver -> {
            MediaType JSON = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)JSON, (String)this.webRtcStats.toJson().toString());
            Call<ResponseBody> user = ((IRestApiTelemetry)this.getApiRestCall()).upload("webrtc", this.webRtcStats.conferenceId, VoxeetSDK.session().getParticipantId(), System.currentTimeMillis(), body);
            long original = System.currentTimeMillis();
            HttpHelper.enqueue(user, (response, object, exception) -> {
                if (null != exception) {
                    solver.reject(HttpHelper.manageThrowableOrServerError(exception, ServerErrorOrigin.TELEMETRY));
                } else {
                    int code = (Integer)Opt.of((Object)response).then(Response::code).or((Object)0);
                    solver.resolve(new TelemetryAnswer<Boolean>(original, (Headers)Opt.of((Object)response).then(Response::headers).orNull(), code >= 200 && code < 300));
                }
            });
        });
    }
}

