/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.media;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.VoxeetSDK;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.utils.Opt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

public class VideoSinkHolder {
    @NonNull
    private WeakReference<VideoSink> holder;
    private ArrayList<MediaStreamListener> mediaStreamListeners = new ArrayList();

    private VideoSinkHolder() {
    }

    public VideoSinkHolder(@NonNull VideoSink videoSink) {
        this();
        this.holder = new WeakReference<VideoSink>(videoSink);
    }

    public boolean hasVideoSink() {
        return this.holder.get() != null;
    }

    public void clear() {
        MediaEngine media = (MediaEngine)Opt.of((Object)VoxeetSDK.mediaDevice()).then(MediaDeviceService::getMedia).orNull();
        this.unattach(media);
    }

    @Nullable
    public MediaStream getMediaStream() {
        for (MediaStreamListener listener : this.mediaStreamListeners) {
            if (!listener.active) continue;
            return listener.mediaStream;
        }
        return null;
    }

    public void attach(@NonNull MediaEngine media, @NonNull MediaStream stream) {
        VideoSink videoSink = (VideoSink)this.holder.get();
        this.unattach(media);
        if (null != videoSink) {
            MediaStreamListener mediaStreamListener = new MediaStreamListener(stream);
            this.mediaStreamListeners.add(mediaStreamListener);
            mediaStreamListener.active = true;
            media.attachMediaStream((VideoSink)mediaStreamListener, stream);
        }
    }

    public void unattach(@Nullable MediaEngine media) {
        VideoSink videoSink = (VideoSink)this.holder.get();
        for (MediaStreamListener mediaStreamListener : this.mediaStreamListeners) {
            if (null != media && null != videoSink && mediaStreamListener.active) {
                media.unattachMediaStream((VideoSink)mediaStreamListener, mediaStreamListener.mediaStream);
            }
            mediaStreamListener.active = false;
        }
        this.mediaStreamListeners.clear();
    }

    public boolean equals(@Nullable Object obj) {
        VideoSink videoSink = (VideoSink)this.holder.get();
        return obj == this || obj instanceof VideoSink && obj.equals(videoSink);
    }

    private class MediaStreamListener
    implements VideoSink {
        public MediaStream mediaStream;
        public boolean active;

        public MediaStreamListener(MediaStream mediaStream) {
            this.mediaStream = mediaStream;
            this.active = true;
        }

        public void onFrame(VideoFrame frame) {
            VideoSink videoSink = (VideoSink)VideoSinkHolder.this.holder.get();
            if (this.active) {
                if (null != videoSink) {
                    videoSink.onFrame(frame);
                }
            } else {
                MediaEngine media = (MediaEngine)Opt.of((Object)VoxeetSDK.mediaDevice()).then(MediaDeviceService::getMedia).orNull();
                if (Opt.isNonNull((Object[])new Object[]{videoSink, media})) {
                    media.unattachMediaStream(videoSink, this.mediaStream);
                }
            }
        }
    }
}

