/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.StopScreenShareAnswerEvent;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiScreenShare;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class StopScreenSharePromise
extends AbstractPromiseable<Boolean, IRestApiScreenShare> {
    private static final String TAG = StopScreenSharePromise.class.getSimpleName();

    public StopScreenSharePromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiScreenShare provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise(solver -> {
            ConferenceInformation information = this.getInformation();
            MediaSDK media = this.getMedia();
            if (null == information || !this.getParent().isInConference()) {
                Log.d((String)TAG, (String)"stopVideo: not in conf");
                if (null != media) {
                    media.stopVideo();
                }
                Promise.reject((Solver)solver, (Throwable)new NotInConferenceException());
                return;
            }
            String conferenceId = information.getConference().getId();
            if (!this.isInConference()) {
                Log.d((String)TAG, (String)"stopScreenShare: not in conf");
                if (null != media) {
                    media.stopScreenCapturer();
                }
                Promise.reject((Solver)solver, (Throwable)new NotInConferenceException());
                return;
            }
            if (!this.hasMedia()) {
                Log.d((String)TAG, (String)"stopScreenShare: media is null");
                Promise.reject((Solver)solver, (Throwable)new MediaEngineException("media is null"));
                return;
            }
            if (null != media) {
                media.stopScreenCapturer();
            }
            Call<StopScreenSharingResponse> stopVideo = ((IRestApiScreenShare)this.getApiRestCall()).stopScreenShare(conferenceId);
            HttpHelper.promise(stopVideo, ServerErrorOrigin.STOP_RECORDING).then(answer -> {
                StopScreenSharingResponse object = (StopScreenSharingResponse)answer.object;
                if (null != media) {
                    media.stopScreenCapturer();
                }
                information.setScreenShareOn(false);
                StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(true);
                this.getEventBus().post((Object)event);
                solver.resolve(this.createVideoAnswer(object.participantId, object.description, object.candidates));
            }).error(error -> {
                information.setScreenShareOn(false);
                StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(false);
                this.getEventBus().post((Object)event);
                solver.reject(error);
            });
        });
    }
}

