/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.events.sdk.ConferenceTimeoutNoParticipantsJoinedEvent;
import com.voxeet.sdk.services.ConferenceService;
import org.greenrobot.eventbus.EventBus;

class TimeoutRunnable
implements Runnable {
    @NonNull
    private EventBus mEventBus;
    @NonNull
    ConferenceService mService;
    private long mTimeout;
    private boolean mCanceled;
    private boolean mTriggered;

    private TimeoutRunnable() {
        this.setCanceled(false);
        this.mTriggered = false;
    }

    TimeoutRunnable(@NonNull ConferenceService service, @NonNull EventBus event_bus, long timeout) {
        this();
        this.mService = service;
        this.mEventBus = event_bus;
        this.mTimeout = timeout;
    }

    void setCanceled(boolean canceled) {
        this.mCanceled = canceled;
    }

    private boolean isCanceled() {
        return this.mCanceled;
    }

    @Override
    public void run() {
        if (!this.isCanceled()) {
            this.mService.leave().then(result -> Log.d((String)"TimeoutRunnable", (String)"run: auto leave")).error(Throwable::printStackTrace);
            this.mEventBus.post((Object)new ConferenceTimeoutNoParticipantsJoinedEvent(this.mTimeout));
            this.mTriggered = true;
        }
    }

    boolean isTriggered() {
        return this.mTriggered;
    }
}

