/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.VoxeetSDK;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.events.sdk.ConferenceStatusUpdatedEvent;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.network.endpoints.IRestApiTelemetry;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.LocalStatsService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.telemetry.SdkEnvironment;
import com.voxeet.sdk.services.telemetry.TelemetryAnswer;
import com.voxeet.sdk.services.telemetry.TelemetryState;
import com.voxeet.sdk.services.telemetry.TelemetryStateUpdated;
import com.voxeet.sdk.services.telemetry.TelemetryTickState;
import com.voxeet.sdk.services.telemetry.TelemetryTickUpdated;
import com.voxeet.sdk.services.telemetry.device.DeviceInformation;
import com.voxeet.sdk.services.telemetry.device.DeviceStats;
import com.voxeet.sdk.services.telemetry.device.HardwareInfo;
import com.voxeet.sdk.services.telemetry.network.NetworkInformationProvider;
import com.voxeet.sdk.services.telemetry.promises.TelemetryConfigurationPromise;
import com.voxeet.sdk.services.telemetry.promises.WebRTCDeviceInfoPromise;
import com.voxeet.sdk.services.telemetry.promises.WebRTCStatsBatchPromise;
import com.voxeet.sdk.services.telemetry.promises.WebRTCStatsPromise;
import com.voxeet.sdk.services.telemetry.rest.TelemetryConfiguration;
import com.voxeet.sdk.telemetry.MetricsHolder;
import com.voxeet.sdk.telemetry.WebRTCStats;
import com.voxeet.sdk.telemetry.utils.TeleLog;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.Map;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;
import com.voxeet.stats.LocalStats;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@Annotate
public class TelemetryService
extends AbstractVoxeetService {
    private static final String TAG = TelemetryService.class.getSimpleName();
    private static ConcurrentHashMap<SdkEnvironment, String> environment = new ConcurrentHashMap();
    private final NetworkInformationProvider networkProvider;
    private WaitForConference waitForConference;
    private Handler _runnable;
    private int _next_publish_in;
    private TelemetryState state = TelemetryState.STOPPED;
    private TelemetryTickState tick_state = TelemetryTickState.AGGREGATE;
    private List<WebRTCStats> temp_stats = new ArrayList<WebRTCStats>();
    @Nullable
    private MetricsHolder previous_metrics = null;
    private Runnable _tick = () -> {
        String conferenceId = (String)Opt.of((Object)VoxeetSDK.conference()).then(ConferenceService::getConferenceId).or((Object)"");
        String userId = (String)Opt.of((Object)VoxeetSDK.session()).then(SessionService::getParticipantId).orNull();
        --this._next_publish_in;
        List<Participant> participants = VoxeetSDK.conference().getParticipants();
        LocalStatsService service = VoxeetSDK.localStats();
        List localStats = Map.map(participants, in -> service.getLocalStats(in.getId()));
        TeleLog.log = true;
        TeleLog.d((String)"TICK", (String)"TICK: >>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        TeleLog.d((String)"TICK", (String)("has previous := " + (null != this.previous_metrics)));
        for (LocalStats stat : localStats) {
            TeleLog.d((String)"TICK", (String)("json := " + stat.userId + " " + stat.getRawJson()));
        }
        WebRTCStats stats = new WebRTCStats(conferenceId, userId, localStats, this.previous_metrics, System.currentTimeMillis());
        TeleLog.d((String)"TICK", (String)("json := " + stats.toJson().toString()));
        TeleLog.d((String)"TICK", (String)"TICK: <<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        this.temp_stats.add(stats);
        this.previous_metrics = stats.metricsHolder;
        if (this._next_publish_in <= 0) {
            this.tick_state = TelemetryTickState.POST;
            this._next_publish_in = this.batch();
            this.flush(conferenceId);
        } else {
            this.tick_state = TelemetryTickState.AGGREGATE;
        }
        this.getEventBus().post((Object)new TelemetryTickUpdated(this.tick_state));
        this.repost();
    };
    @Nullable
    private TelemetryConfiguration configuration;
    private boolean device_information_sent;
    private Runnable _ttl = () -> {
        if (null != this.configuration && this.configuration.needRefresh()) {
            this.configuration().then(this::setConfigurationAfterRetrieval).error(Throwable::printStackTrace);
        }
    };

    @NoDocumentation
    public TelemetryService(SdkEnvironmentHolder sdk_environment_holder) {
        super(sdk_environment_holder);
        this.waitForConference = new WaitForConference();
        this.getEventBus().register((Object)this.waitForConference);
        this.networkProvider = new NetworkInformationProvider(sdk_environment_holder.voxeetSdk.getApplicationContext());
        TelemetryService.register(SdkEnvironment.SDK, "2.2.0");
        TelemetryService.register(SdkEnvironment.MEDIA, "1.72.40");
    }

    public Promise<DeviceInformation> deviceInformation() {
        return new Promise(solver -> {
            HardwareInfo info = new HardwareInfo(this.context);
            VoxeetSDK.audio().enumerateDevices().then(devices -> solver.resolve((Object)new DeviceInformation(info, true, environment, (List<MediaDevice>)devices, this.networkProvider.carriers(), this.networkProvider.wifiInfo()))).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }

    private void trySendDeviceInformation() {
        if (!this.device_information_sent) {
            this.device_information_sent = true;
            this.deviceInformation().then(deviceInformation -> {
                DeviceStats stats = new DeviceStats(VoxeetSDK.session().getParticipantId(), (DeviceInformation)deviceInformation, System.currentTimeMillis());
                return new WebRTCDeviceInfoPromise(VoxeetSDK.conference(), VoxeetSDK.mediaDevice(), this.getService(IRestApiTelemetry.class), null, this.getEventBus(), stats).createPromise();
            }).then(booleanTelemetryAnswer -> Log.d((String)TAG, (String)"call: device information sent")).error(error -> {
                this.device_information_sent = false;
                error.printStackTrace();
            });
        }
    }

    @NonNull
    private Promise<TelemetryConfiguration> configuration() {
        if (null != this.configuration && !this.configuration.needRefresh()) {
            return Promise.resolve((Object)this.configuration);
        }
        return new TelemetryConfigurationPromise(VoxeetSDK.conference(), VoxeetSDK.mediaDevice(), this.getService(IRestApiTelemetry.class), null, this.getEventBus()).createPromise();
    }

    @NonNull
    private Promise<TelemetryAnswer<Boolean>> upload(@NonNull String conferenceId, WebRTCStats stats) {
        return new WebRTCStatsPromise(VoxeetSDK.conference(), VoxeetSDK.mediaDevice(), this.getService(IRestApiTelemetry.class), VoxeetSDK.conference().getConferenceInformation(conferenceId), this.getEventBus(), stats).createPromise();
    }

    @NonNull
    private Promise<TelemetryAnswer<Boolean>> upload(@NonNull String conferenceId, List<WebRTCStats> stats) {
        return new WebRTCStatsBatchPromise(VoxeetSDK.conference(), VoxeetSDK.mediaDevice(), this.getService(IRestApiTelemetry.class), VoxeetSDK.conference().getConferenceInformation(conferenceId), this.getEventBus(), stats).createPromise();
    }

    @NoDocumentation
    @NonNull
    public TelemetryState getState() {
        return this.state;
    }

    @NoDocumentation
    @NonNull
    public TelemetryTickState getTickState() {
        return this.tick_state;
    }

    private int batch() {
        return (Integer)Opt.of((Object)this.configuration).then(TelemetryConfiguration::batch).or((Object)3);
    }

    private int samplingFreq() {
        return (Integer)Opt.of((Object)this.configuration).then(TelemetryConfiguration::samplingFreqSec).or((Object)10) * 1000;
    }

    private void flush(@NonNull String conferenceId) {
        if (this.temp_stats.size() > 0) {
            this.upload(conferenceId, this.temp_stats).then(result -> Log.d((String)TAG, (String)("uploaded stats " + result))).error(Throwable::printStackTrace);
            this.temp_stats = new ArrayList<WebRTCStats>();
        }
    }

    private synchronized void start() {
        this.trySendDeviceInformation();
        if (null == this._runnable) {
            Handler handler;
            this.device_information_sent = false;
            String conferenceId = (String)Opt.of((Object)VoxeetSDK.conference().getConferenceId()).orNull();
            this.setState(TelemetryState.STARTING);
            this._runnable = handler = new Handler(Looper.getMainLooper());
            this.configuration().then(configuration -> {
                if (null == configuration) {
                    throw new IllegalStateException("Couldn't load");
                }
                if (!configuration.enabled()) {
                    throw new IllegalStateException("Stopped telemetry");
                }
                this.setConfigurationAfterRetrieval((TelemetryConfiguration)configuration);
                Log.d((String)TAG, (String)("start: configuration := " + configuration));
                this.trySendDeviceInformation();
                this._next_publish_in = this.batch();
                this.setState(TelemetryState.STARTED);
                handler.removeCallbacks(this._tick);
                handler.postDelayed(this._tick, (long)this.samplingFreq());
            }).error(error -> this.stop(conferenceId));
        }
    }

    private void setConfigurationAfterRetrieval(@Nullable TelemetryConfiguration configuration) {
        if (null != configuration) {
            this.configuration = configuration;
            this.postForConfigurationInvalidation();
        }
    }

    private void postForConfigurationInvalidation() {
        handler.removeCallbacks(this._ttl);
        if (null != this.configuration) {
            handler.postDelayed(this._ttl, (this.configuration.ttl + 10L) * 1000L);
        }
    }

    private synchronized void stop(@Nullable String conferenceId) {
        if (null != this._runnable) {
            this.previous_metrics = null;
            this.device_information_sent = false;
            this.setState(TelemetryState.STOPPED);
            this._runnable.removeCallbacks(this._tick);
            this._runnable = null;
            if (null != conferenceId) {
                this.flush(conferenceId);
            }
        }
    }

    private void repost() {
        if (null != this.configuration) {
            this._runnable.postDelayed(this._tick, (long)this.samplingFreq());
        }
    }

    private void setState(@NonNull TelemetryState state) {
        this.state = state;
        this.getEventBus().post((Object)new TelemetryStateUpdated(state));
    }

    @NoDocumentation
    public void registerEnvironment(@Nullable SdkEnvironment name, @Nullable String value) {
        TelemetryService.register(name, value);
    }

    @NoDocumentation
    public static void register(@Nullable SdkEnvironment name, @Nullable String value) {
        if (null != name && null != value && !environment.contains((Object)name)) {
            environment.put(name, value);
        }
    }

    private class WaitForConference {
        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull SocketStateChangeEvent event) {
            switch (event.state) {
                case CONNECTED: {
                    TelemetryService.this.configuration().then(configuration -> {
                        if (null != configuration) {
                            TelemetryService.this.configuration = configuration;
                        }
                    }).error(Throwable::printStackTrace);
                    break;
                }
            }
        }

        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull ConferenceStatusUpdatedEvent event) {
            switch (event.state) {
                case CREATING: 
                case CREATED: {
                    break;
                }
                case JOINING: 
                case JOINED: 
                case FIRST_PARTICIPANT: 
                case NO_MORE_PARTICIPANT: {
                    TelemetryService.this.start();
                    break;
                }
                default: {
                    TelemetryService.this.stop((String)Opt.of((Object)event.conference).then(Conference::getId).orNull());
                }
            }
        }
    }
}

