/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.VoxeetSDK;
import com.voxeet.audio.utils.Log;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.sdk.ConferenceStatusUpdatedEvent;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ConferenceEnded;
import com.voxeet.sdk.media.audio.AudioRoute;
import com.voxeet.sdk.media.audio.SoundManager;
import com.voxeet.sdk.media.sensors.ConferenceLock;
import com.voxeet.sdk.media.sensors.ProximitySensor;
import com.voxeet.sdk.media.sensors.ScreenSensor;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.AudioType;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.voiceengine.WebRtcAudioUtils;

@Annotate
public class AudioService
extends AbstractVoxeetService {
    private static SoundManager sSoundManager;
    private static final String TAG;
    private List<ConferenceLock> locks = new ArrayList<ConferenceLock>();
    private Boolean speakerMode = null;

    @NoDocumentation
    public AudioService(@NonNull SdkEnvironmentHolder instance) {
        super(instance);
        AudioService.preInitSounds(instance.voxeetSdk.getApplicationContext());
        sSoundManager.registerUpdateDevices(this::tryConnectFirst);
        this.registerEventBus();
        this.locks.add(new ProximitySensor(instance.voxeetSdk.getApplicationContext()));
        this.locks.add(new ScreenSensor(instance.voxeetSdk.getApplicationContext()));
    }

    @Nullable
    public static SoundManager getSoundManager() {
        return sSoundManager;
    }

    public static boolean preInitSounds(@NonNull Context applicationContext) {
        if (null == sSoundManager) {
            sSoundManager = new SoundManager(applicationContext);
            return true;
        }
        return false;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    @NoDocumentation
    public void onEvent(ConferenceStatusUpdatedEvent event) {
        if (ConferenceStatus.JOINING.equals((Object)event.state)) {
            this.enableAec(true);
            this.enableNoiseSuppressor(true);
            this.updateSensors(this.currentRoute());
            sSoundManager.onConferencePreJoinedEvent();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    @NoDocumentation
    public void onEvent(ConferenceEnded event) {
        sSoundManager.onConferenceDestroyedPush();
        this.releaseSensors();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    @NoDocumentation
    public void onEvent(ConferenceDestroyedPush event) {
        sSoundManager.onConferenceDestroyedPush();
        this.releaseSensors();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return sSoundManager.getAvailableRoutes();
    }

    @NonNull
    public AudioRoute currentRoute() {
        return sSoundManager.currentRoute();
    }

    public boolean registerUpdateDevices(SoundManager.Call<List<MediaDevice>> callback) {
        return sSoundManager.registerUpdateDevices(callback);
    }

    public void unregisterUpdateDevices(SoundManager.Call<List<MediaDevice>> callback) {
        sSoundManager.unregisterUpdateDevices(callback);
    }

    public boolean isNotFiltered(@NonNull MediaDevice device) {
        return sSoundManager.isNotFiltered(device);
    }

    @NonNull
    public Promise<List<MediaDevice>> enumerateDevices() {
        return sSoundManager.enumerateDevices();
    }

    @NonNull
    public Promise<Boolean> connect(@NonNull MediaDevice device) {
        return sSoundManager.connect(device);
    }

    @NonNull
    public Promise<Boolean> disconnect(@NonNull MediaDevice device) {
        return sSoundManager.disconnect(device);
    }

    @Deprecated
    public boolean setAudioRoute(@NonNull AudioRoute route) {
        boolean new_switch = sSoundManager.setAudioRoute(route);
        this.updateSensors(this.currentRoute());
        return new_switch;
    }

    @NonNull
    public AudioService checkOutputRoute() {
        sSoundManager.checkOutputRoute();
        return this;
    }

    @Deprecated
    public void setSpeakerMode(boolean isSpeaker) {
        this.speakerMode = isSpeaker;
        sSoundManager.setSpeakerMode(isSpeaker);
        this.updateSensors(this.currentRoute());
    }

    @Deprecated
    public boolean isBluetoothHeadsetConnected() {
        return sSoundManager.isBluetoothHeadsetConnected();
    }

    @Deprecated
    public boolean isWiredHeadsetOn() {
        return sSoundManager.isWiredHeadsetOn();
    }

    @Deprecated
    public boolean isSpeakerOn() {
        return sSoundManager.isSpeakerOn();
    }

    @NonNull
    public AudioService acquireLocks() {
        sSoundManager.acquireLocks();
        return this;
    }

    @NonNull
    public AudioService releaseLocks() {
        sSoundManager.releaseLocks();
        return this;
    }

    @Deprecated
    @NonNull
    public AudioService resetDefaultSoundType() {
        sSoundManager.resetDefaultSoundType();
        return this;
    }

    @NonNull
    public AudioService abandonAudioFocusRequest() {
        sSoundManager.abandonAudioFocusRequest();
        return this;
    }

    @NonNull
    public AudioService requestAudioFocus() {
        sSoundManager.requestAudioFocus();
        return this;
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return sSoundManager.setSound(type, assetName);
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName, int soundMode) {
        return sSoundManager.setSound(type, assetName, soundMode);
    }

    @NonNull
    public AudioService playSoundType(@NonNull AudioType type) {
        sSoundManager.playSoundType(type);
        return this;
    }

    @NonNull
    public AudioService playSoundType(@NonNull AudioType type, int soundMode) {
        sSoundManager.playSoundType(type, soundMode);
        return this;
    }

    @NonNull
    public AudioService stopSoundType(@NonNull AudioType audioType) {
        sSoundManager.stopSoundType(audioType);
        return this;
    }

    @NonNull
    public AudioService stopSoundType(@NonNull AudioType audioType, int soundMode) {
        sSoundManager.stopSoundType(audioType, soundMode);
        return this;
    }

    @NonNull
    public AudioService stop() {
        sSoundManager.stop();
        return this;
    }

    @NonNull
    public AudioService enable() {
        sSoundManager.enable();
        return this;
    }

    @Deprecated
    @NonNull
    public AudioService enableMedia() {
        sSoundManager.enableMedia();
        return this;
    }

    @Deprecated
    @NonNull
    public AudioService unsetMediaRoute() {
        sSoundManager.unsetMediaRoute();
        return this;
    }

    @Deprecated
    @NonNull
    public AudioService setMediaRoute() {
        sSoundManager.setMediaRoute();
        return this;
    }

    @NonNull
    public AudioService disable() {
        sSoundManager.disable();
        this.stop();
        return this;
    }

    public void updateSensors(@NonNull AudioRoute route) {
        for (ConferenceLock lock : this.locks) {
            if (!route.useProximitySensor() && lock.isProximity()) {
                lock.release();
                continue;
            }
            lock.acquire();
        }
    }

    public void releaseSensors() {
        android.util.Log.d((String)"ProximitySensor", (String)"releaseSensors: ");
        for (ConferenceLock lock : this.locks) {
            lock.release();
        }
    }

    public boolean enableAec(boolean enable) {
        WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)enable);
        return true;
    }

    public boolean enableNoiseSuppressor(boolean enable) {
        WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)enable);
        return true;
    }

    @NoDocumentation
    public void checkDevicesToConnectOnConference(boolean speaker) {
        if (VoxeetSDK.conference().isLive()) {
            this.speakerMode = speaker;
            this.enumerateDevices().then(m -> this.tryConnectFirst((List<MediaDevice>)m, speaker)).error(Throwable::printStackTrace);
        }
    }

    private void tryConnectFirst(List<MediaDevice> mediaDevices) {
        this.tryConnectFirst(mediaDevices, null);
    }

    private void tryConnectFirst(List<MediaDevice> mediaDevices, Boolean speaker) {
        boolean hasConnecting = false;
        MediaDevice internal = null;
        MediaDevice current = null;
        for (MediaDevice device : mediaDevices) {
            if (DeviceType.INTERNAL_SPEAKER.equals((Object)device.deviceType())) {
                internal = device;
            }
            switch (device.connectionState()) {
                case CONNECTING: {
                    hasConnecting = true;
                    break;
                }
                case CONNECTED: {
                    if (DeviceType.NORMAL_MEDIA.equals((Object)device.deviceType())) break;
                    current = device;
                }
            }
        }
        if (!VoxeetSDK.conference().isLive()) {
            android.util.Log.d((String)TAG, (String)"update of devices without a conference... returning...");
            if (null != current && !ConnectionState.DISCONNECTING.equals((Object)current.connectionState()) && ConnectionState.CONNECTED.equals((Object)current.connectionState())) {
                this.disconnect(current).then(c -> {}).error(Throwable::printStackTrace);
            }
            return;
        }
        Log.d((String)TAG, (String)("speakerMode ? " + this.speakerMode + " speaker ? " + speaker));
        if (null != current && ConnectionState.DISCONNECTED.equals((Object)current.platformConnectionState())) {
            current = null;
        }
        Log.d((String)TAG, (String)("current ? " + current + " hasConnecting ? " + hasConnecting));
        if (!hasConnecting) {
            DeviceType type = (DeviceType)Opt.of((Object)current).then(MediaDevice::deviceType).or((Object)DeviceType.INTERNAL_SPEAKER);
            List<MediaDevice> bluetooths = this.ofType(mediaDevices, DeviceType.BLUETOOTH);
            List<MediaDevice> wireds = this.ofType(mediaDevices, DeviceType.WIRED_HEADSET);
            List<MediaDevice> external = this.ofType(mediaDevices, DeviceType.EXTERNAL_SPEAKER);
            List<MediaDevice> not_speaker = this.ofType(mediaDevices, DeviceType.INTERNAL_SPEAKER);
            Promise<Boolean> connect = null;
            if (!DeviceType.BLUETOOTH.equals((Object)type) && bluetooths.size() > 0) {
                Log.d((String)TAG, (String)("has bluetooth to connect to " + bluetooths));
                connect = this.connect(bluetooths.get(0));
            } else if (!DeviceType.WIRED_HEADSET.equals((Object)type) && wireds.size() > 0) {
                connect = this.connect(wireds.get(0));
            }
            if (null != speaker) {
                this.speakerMode = speaker;
            }
            if (null == connect && null != this.speakerMode) {
                Log.d((String)TAG, (String)"connecting to speaker ? ");
                if (null != current) {
                    Log.d((String)TAG, (String)"have a current device");
                } else if (this.speakerMode.booleanValue() && !DeviceType.EXTERNAL_SPEAKER.equals((Object)type) && external.size() > 0) {
                    connect = this.connect(external.get(0));
                } else if (not_speaker.size() > 0) {
                    connect = this.connect(not_speaker.get(0));
                }
            }
            Log.d((String)TAG, (String)("connecting to a device ... " + connect + " " + this.speakerMode));
            if (null != connect) {
                connect.then(result -> {
                    Log.d((String)"AudioService", (String)("finished connecting automatically to the device... " + (Object)((Object)this.currentRoute())));
                    this.updateSensors(this.currentRoute());
                }).error(Throwable::printStackTrace);
            } else {
                Log.d((String)"AudioService", (String)("update simply the route " + (Object)((Object)this.currentRoute())));
                this.updateSensors(this.currentRoute());
            }
        } else {
            Log.d((String)TAG, (String)"has connecting in progress");
        }
    }

    private List<MediaDevice> ofType(List<MediaDevice> mediaDevices, DeviceType type) {
        ArrayList<MediaDevice> list = new ArrayList<MediaDevice>();
        for (MediaDevice device : mediaDevices) {
            if (!type.equals((Object)device.deviceType()) || !this.isNotFiltered(device) || !ConnectionState.CONNECTED.equals((Object)device.platformConnectionState())) continue;
            list.add(device);
        }
        return list;
    }

    public Promise<MediaDevice> currentMediaDevice() {
        return sSoundManager.current();
    }

    static {
        TAG = AudioService.class.getSimpleName();
    }
}

