/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.VoxeetSDK;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.models.v1.RestParticipant;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

@Annotate
public class Conference {
    private ReentrantLock lock = new ReentrantLock();
    private static final String TAG = "Conference";
    @NonNull
    private String id;
    @Nullable
    private String alias;
    @NonNull
    private CopyOnWriteArrayList<Participant> participants;
    @Nullable
    private Participant mixer;
    @Nullable
    private ConferenceInfos conferenceInfos;
    @Nullable
    private RecordingInformation recordingInformation;
    @NonNull
    private ConferenceInformation conferenceInformation;

    private Conference() {
    }

    @NoDocumentation
    public Conference(@NonNull ConferenceInformation conferenceInformation) {
        this.participants = new CopyOnWriteArrayList();
        this.id = "";
        this.conferenceInformation = conferenceInformation;
    }

    @NoDocumentation
    public Conference(com.voxeet.sdk.models.v1.Conference fromConference, @NonNull ConferenceInformation conferenceInformation) {
        this();
        this.updateParticipants(fromConference.getConferenceUsers());
        this.id = fromConference.getConferenceId();
        this.alias = fromConference.getConferenceAlias();
        this.conferenceInformation = conferenceInformation;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @NonNull
    public CopyOnWriteArrayList<Participant> getParticipants() {
        return this.participants;
    }

    public boolean hasAny(@NonNull ConferenceParticipantStatus status, boolean local) {
        String id = VoxeetSDK.session().getParticipantId();
        if (null == id) {
            id = "";
        }
        for (Participant participant : this.participants) {
            if (null == participant || !status.equals((Object)participant.getStatus()) || !local && id.equals(participant.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalStreams(boolean includeLocalParticipant) {
        String id = VoxeetSDK.session().getParticipantId();
        if (null == id) {
            id = "";
        }
        for (Participant participant : this.participants) {
            if (null == participant) continue;
            boolean properStatus = ConferenceParticipantStatus.ON_AIR.equals((Object)participant.getStatus());
            if (!(properStatus |= ConferenceParticipantStatus.CONNECTING.equals((Object)participant.getStatus())) || participant.streams().size() <= 0 || !includeLocalParticipant && id.equals(participant.getId())) continue;
            return true;
        }
        return false;
    }

    @NoDocumentation
    @NonNull
    public Conference updateParticipants(ConferenceUser participant) {
        this.lock();
        Participant internalParticipant = this.getInternalParticipantInConference(participant);
        if (null == internalParticipant) {
            this.log("updateParticipants: create RestParticipant from ConferenceUser := " + new Participant(participant));
            this.addParticipant(new Participant(participant));
        } else {
            internalParticipant.updateStatus(participant.getConferenceStatus());
        }
        this.unlock();
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateParticipant(@NonNull RestParticipant participant) {
        Participant internalParticipant = this.getInternalParticipantInConference(participant);
        this.lock();
        if (null == internalParticipant) {
            String externalId = participant.getExternalId();
            Participant existing = this.findParticipantByExternalId(externalId);
            if (null != existing) {
                this.log("updateParticipant: existing participant, updating hi\u00b7er");
                existing.updateIfNeeded(participant.getName(), participant.getAvatarUrl());
            } else {
                this.log("updateParticipant: new participant, adding hi\u00b7er, ");
                this.addParticipant(new Participant(participant));
            }
        } else {
            internalParticipant.updateStatus(ConferenceParticipantStatus.fromString((String)participant.getStatus()));
        }
        this.unlock();
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateParticipant(Participant participant) {
        this.lock();
        Participant internalParticipant = this.getInternalParticipantInConference(participant);
        if (null == internalParticipant) {
            this.log("updateParticipants: create RestParticipant from RestParticipant := " + participant);
            this.addParticipant(participant);
        } else {
            internalParticipant.updateStatus(participant.getStatus());
        }
        this.unlock();
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateParticipants(List<ConferenceUser> users) {
        this.lock();
        try {
            for (ConferenceUser user : users) {
                this.updateParticipants(user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.unlock();
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateRestParticipants(List<RestParticipant> participants) {
        try {
            for (RestParticipant participant : participants) {
                this.updateParticipant(participant);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Nullable
    private Participant getInternalParticipantInConference(ConferenceUser participant) {
        try {
            for (Participant u : this.participants) {
                if (!u.equals(participant)) continue;
                return u;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private Participant getInternalParticipantInConference(Participant participant) {
        try {
            for (Participant u : this.participants) {
                if (!u.equals(participant)) continue;
                return u;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private Participant getInternalParticipantInConference(RestParticipant participant) {
        try {
            for (Participant u : this.participants) {
                if (!u.equals(participant)) continue;
                return u;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @NoDocumentation
    public Conference setConferenceId(@NonNull String id) {
        this.id = id;
        return this;
    }

    @NoDocumentation
    public Conference setConferenceAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public boolean hasMixer() {
        return null != this.mixer && ConferenceParticipantStatus.ON_AIR.equals((Object)this.mixer.getStatus());
    }

    private boolean isMixer(@NonNull Participant participant) {
        ParticipantInfo participantInfo = participant.getInfo();
        String name = null != participantInfo ? participantInfo.getName() : null;
        return null != name && "Mixer".equalsIgnoreCase(name.trim());
    }

    @Nullable
    public Participant findParticipantById(@Nullable String participantId) {
        if (null == participantId) {
            return null;
        }
        for (Participant participant : this.participants) {
            if (!participantId.equals(participant.getId())) continue;
            return participant;
        }
        SessionService sessionService = VoxeetSDK.session();
        if (null == sessionService) {
            return null;
        }
        String localParticipantId = sessionService.getParticipantId();
        if (null != localParticipantId && localParticipantId.equals(participantId)) {
            Log.d((String)TAG, (String)"findParticipantById: participant not found but local one, creating a TEMP ONE ONLY");
            return sessionService.getParticipant();
        }
        return null;
    }

    @Nullable
    public Participant findParticipantByExternalId(@Nullable String externalId) {
        if (null == externalId) {
            return null;
        }
        for (Participant participant : this.participants) {
            ParticipantInfo participantInfo = participant.getInfo();
            if (null == participantInfo || !externalId.equals(participantInfo.getExternalId())) continue;
            return participant;
        }
        return null;
    }

    @NoDocumentation
    public void setConferenceInfos(@NonNull ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Nullable
    public ConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    @NoDocumentation
    public void setRecordingInformation(@Nullable RecordingInformation recordingInformation) {
        this.recordingInformation = recordingInformation;
    }

    @Nullable
    public RecordingInformation getRecordingInformation() {
        return this.recordingInformation;
    }

    private void addParticipant(@NonNull Participant participant) {
        this.dumpParticipants();
        if (this.isMixer(participant)) {
            this.mixer = participant;
        } else {
            this.participants.add(participant);
        }
    }

    private void dumpParticipants() {
        StringBuilder u = new StringBuilder();
        for (Participant participant : this.participants) {
            u.append(participant.getId()).append(",");
        }
        this.log(u.toString());
    }

    @NonNull
    public ConferenceStatus getState() {
        return this.conferenceInformation.getConferenceState();
    }

    private void log(@NonNull String string) {
        Log.d((String)TAG, (String)("log: " + string));
    }

    private void lock() {
        try {
            this.lock.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unlock() {
        try {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class RecordingInformation {
        private Date startRecordTimestamp;
        private RecordingStatus recordingStatus;
        private String recordingParticipant;

        public void setStartRecordTimestamp(Date startRecordTimestamp) {
            this.startRecordTimestamp = startRecordTimestamp;
        }

        public Date getStartRecordTimestamp() {
            return this.startRecordTimestamp;
        }

        public void setRecordingStatus(RecordingStatus recordingStatus) {
            this.recordingStatus = recordingStatus;
        }

        public RecordingStatus getRecordingStatus() {
            return this.recordingStatus;
        }

        public void setRecordingParticipant(String recordingParticipant) {
            this.recordingParticipant = recordingParticipant;
        }

        public String getRecordingParticipant() {
            return this.recordingParticipant;
        }
    }
}

