package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceUser;

import java.util.ArrayList;
import java.util.List;

public class ConferenceUtils {

    /**
     * The constant MUTE_FACTOR.
     */
    public static final int MUTE_FACTOR = 10000;

    /**
     * The constant UNMUTE_FACTOR.
     */
    public static final int UNMUTE_FACTOR = 1;


    private ConferenceUtils() {

    }

    @Nullable
    public static ConferenceUser findConferenceUserById(@Nullable final String userId,
                                    @Nullable List<ConferenceUser> users) {
        if(null != users) {
            for (ConferenceUser user : users) {
                if(null != userId && userId.equalsIgnoreCase(user.getUserId())) {
                    return user;
                }
            }
        }
        return null;
    }

    @Nullable
    public static Participant findUserById(@Nullable final String userId,
                                           @Nullable List<Participant> participants) {
        if(null != participants) {
            for (Participant participant : participants) {
                if(null != userId && userId.equalsIgnoreCase(participant.getId())) {
                    return participant;
                }
            }
        }
        return null;
    }

    @NonNull
    public static List<Participant> findParticipantsMatching(@Nullable String currentUserOrEmpty, @Nullable List<Participant> merged_list) {
        List<Participant> list = new ArrayList<>();
        if(null != currentUserOrEmpty && null != merged_list) {
            for (Participant participant : merged_list) {
                if(null != participant && currentUserOrEmpty.equalsIgnoreCase(participant.getId())) {
                    list.add(participant);
                }
            }
        }
        return list;
    }

    public static List<Participant> getUserInState(List<Participant> conferenceParticipants, ConferenceParticipantStatus status) {
        List<Participant> participants = new ArrayList<>();
        for (Participant participant : conferenceParticipants) {
            if(null != participant && status.equals(participant.getStatus())) {
                participants.add(participant);
            }
        }

        return participants;
    }

    public static List<ConferenceUser> getConferenceUserInState(List<ConferenceUser> conferenceUsers, ConferenceParticipantStatus status) {
        List<ConferenceUser> users = new ArrayList<>();
        for (ConferenceUser user : conferenceUsers) {
            if(null != user && status.equals(user.getConferenceStatus())) {
                users.add(user);
            }
        }

        return users;
    }
}
