package com.voxeet.sdk.services.telemetry.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.utils.Opt;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TelemetryConfiguration {

    public long ttl = 3600;

    public WebRtc webrtc;

    public Dvc dvc;

    public Device device;

    private long _timestamp = 0;

    public TelemetryConfiguration() {
        _timestamp = System.currentTimeMillis();
    }

    public TelemetryConfiguration(long ttl) {
        this.ttl = ttl;
        _timestamp = System.currentTimeMillis();
    }

    public boolean needRefresh() {
        long diff = System.currentTimeMillis() - _timestamp;

        return diff > (ttl * 1000);
    }

    public boolean enabled() {
        if (samplingFreqSec() == 0 || batch() == 0) return false;
        return Opt.of(webrtc).then(w -> w.enabled).or(false);
    }

    public int samplingFreqSec() {
        return Opt.of(webrtc).then(w -> w.samplingFreqSec).or(10);
    }

    public int batch() {
        return Opt.of(webrtc).then(w -> w.batch).or(3);
    }

    @Override
    public String toString() {
        return "TelemetryConfiguration{" +
                "ttl=" + ttl +
                ", webrtc=" + webrtc +
                ", dvc=" + dvc +
                ", device=" + device +
                ", _timestamp=" + _timestamp +
                '}';
    }

    public class WebRtc {
        public boolean enabled = true;
        public int samplingFreqSec = 10;
        public int batch = 3;

        @Override
        public String toString() {
            return "WebRtc{" +
                    "enabled=" + enabled +
                    ", samplingFreqSec=" + samplingFreqSec +
                    ", batch=" + batch +
                    '}';
        }
    }

    public class Dvc {
        @Override
        public String toString() {
            return "Dvc{" +
                    "enabled=" + enabled +
                    '}';
        }

        public boolean enabled = true;
    }

    public class Device {
        @Override
        public String toString() {
            return "Device{" +
                    "enabled=" + enabled +
                    '}';
        }

        public boolean enabled = true;
    }
}
