package com.voxeet.sdk.services.telemetry.network.carriers;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.telephony.SubscriptionManager;

import com.voxeet.sdk.services.telemetry.network.CarrierInfo;
import com.voxeet.sdk.services.telemetry.network.CarrierProvider;
import com.voxeet.sdk.utils.Map;
import com.voxeet.sdk.utils.Opt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP_MR1)
public class CarrierProvider16 extends CarrierProvider {

    private final Context application;

    @Nullable
    private SubscriptionManager subscriptionManager;

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP_MR1)
    public CarrierProvider16(@NonNull Context application) {
        super(application);
        this.application = application;
        subscriptionManager = (SubscriptionManager) application.getSystemService(Context.TELEPHONY_SUBSCRIPTION_SERVICE);
    }

    @Override
    public List<CarrierInfo> carriers() {
        if (ActivityCompat.checkSelfPermission(application, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED
                || Opt.of(subscriptionManager).then(SubscriptionManager::getActiveSubscriptionInfoList).then(List::size).or(0) <= 1) {
            return Collections.singletonList(new CarrierInfo(telephoneManager.getSimOperator(),
                    telephoneManager.getSimCountryIso(),
                    telephoneManager.getSimOperatorName()));
        }

        //having multiple information, send the various sim
        return Map.map(Opt.of(subscriptionManager).then(SubscriptionManager::getActiveSubscriptionInfoList).or(new ArrayList<>()),
                subscriptionInfo -> new CarrierInfo(subscriptionInfo.getCarrierName(),
                        subscriptionInfo.getCountryIso(),
                        subscriptionInfo.getDisplayName()));
    }
}
