package com.voxeet.sdk.services.telemetry.network;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;

import com.voxeet.sdk.services.telemetry.network.carriers.CarrierProvider16;
import com.voxeet.sdk.services.telemetry.network.carriers.CarrierProviderPre16;
import com.voxeet.sdk.services.telemetry.network.wifi.Wifi;
import com.voxeet.sdk.utils.Opt;

import java.util.List;

public class NetworkInformationProvider {

    private CarrierProvider carrierProvider;
    @NonNull
    private TelephonyManager telephonyManager;

    @NonNull
    private WifiManager wifiManager;

    private NetworkInformationProvider() {

    }

    public NetworkInformationProvider(@NonNull Context context) {
        wifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            carrierProvider = new CarrierProvider16(context);
        } else {
            carrierProvider = new CarrierProviderPre16(context);
        }
    }

    @Nullable
    public Wifi wifiInfo() {
        return Opt.of(wifiManager).then(WifiManager::getConnectionInfo).then(Wifi::new).orNull();
    }

    @NonNull
    public List<CarrierInfo> carriers() {
        return carrierProvider.carriers();
    }
}
