package com.voxeet.sdk.services.telemetry.network;

import android.content.Context;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;

import java.util.List;

public abstract class CarrierProvider {

    @NonNull
    protected TelephonyManager telephoneManager;

    protected CarrierProvider(@NonNull Context context) {
        telephoneManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
    }

    public abstract List<CarrierInfo> carriers();
}
