package com.voxeet.sdk.services.telemetry.codec;


import android.media.MediaCodecInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.utils.Map;
import com.voxeet.sdk.utils.Opt;

import org.webrtc.MediaCodecVideoHelperFactory;

import java.util.ArrayList;
import java.util.List;

public class Codec {
    @NonNull
    public String name;

    public boolean encoder;

    @Nullable
    //public List<String> mimes;
    public String mime;

    public Codec(@NonNull String name, boolean encoder, @Nullable List<String> mimes) {
        this.name = name;
        this.encoder = encoder;
        this.mime = Opt.of(mimes).then(c -> c.size() > 0 ? c.get(0) : null).orNull();
    }

    public static List<Codec> list() {
        try {
            ArrayList<MediaCodecInfo> list = MediaCodecVideoHelperFactory.getCodecs();
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                return Map.map(list, codecInfo -> {
                    List<MediaCodecInfo.CodecCapabilities> capabilities = Map.map(codecInfo.getSupportedTypes(), codecInfo::getCapabilitiesForType);
                    capabilities = Map.filter(capabilities, s -> null != s);

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        return new Codec(codecInfo.getName(),
                                codecInfo.isEncoder(),
                                Map.map(capabilities, MediaCodecInfo.CodecCapabilities::getMimeType));
                    }
                    return new Codec(codecInfo.getName(), codecInfo.isEncoder(), null);
                });
            }
        } catch (Exception e) {

        }

        return null;
    }
}