package com.voxeet.sdk.services.telemetry;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

import okhttp3.Headers;


public class TelemetryAnswer<TYPE> {

    public final long original;
    public final long current;
    @Nullable
    public Date date;

    @NonNull
    public TYPE holder;

    public TelemetryAnswer(long original,
                           @Nullable Headers headers,
                           @NonNull TYPE holder) {
        this.original = original;
        this.current = System.currentTimeMillis();
        this.date = null;
        if (null != headers) {
            for (String name : headers.names()) {
                if ("date".equalsIgnoreCase(name)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                    dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));

                    try {
                        date = dateFormat.parse(headers.get(name));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.holder = holder;
    }

    @Override
    public String toString() {
        return "TelemetryAnswer{" +
                "original=" + original +
                ", current=" + current +
                ", date=" + date +
                ", holder=" + holder +
                '}';
    }


}
