package com.voxeet.sdk.services.notification.internal;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.ParticipantNotification;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.services.notification.internal.EventParticipant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.Map;
import com.voxeet.sdk.utils.MapCallback;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;

import java.util.ArrayList;
import java.util.List;

@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_UPDATED_NOTIFICATION)
public class WebsocketConferenceStatusNotificationEvent extends Event {

    @JsonProperty("confId")
    @Nullable
    public String conferenceId;

    @JsonProperty("confAlias")
    @Nullable
    public String conferenceAlias;

    @JsonProperty("live")
    @Nullable
    public boolean isLive;

    @JsonProperty("startTimestamp")
    @Nullable
    public long startTimestamp;

    public List<EventParticipant> participants;

    public List<ParticipantNotification> asParticipants() {
        return Map.map(Opt.of(participants).or(new ArrayList<>()),
                participant -> new ParticipantNotification(
                        Opt.of(participant).then(c -> c.userId).or(""),
                        new ParticipantInfo(
                                Opt.of(participant).then(c -> c.externalName).or(""),
                                Opt.of(participant).then(c -> c.externalId).or(""),
                                Opt.of(participant).then(c -> c.externalAvatarUrl).or("")
                        ),
                        ConferenceParticipantStatus.fromString(Opt.of(participant).then(c -> c.status).or(""))
                ));
    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.CONFERENCE_UPDATED_NOTIFICATION;
    }
}
