package com.voxeet.sdk.services.notification.internal;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.ParticipantNotification;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.push.center.subscription.event.ParticipantLeftNotificationEvent;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.Opt;

@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.PARTICIPANT_LEFT_NOTIFICATION)
public class WebSocketParticipantLeft extends Event {

    @NonNull
    public EventConference conference;

    @NonNull
    public EventParticipant participant;

    public ParticipantLeftNotificationEvent to() {
        return new ParticipantLeftNotificationEvent(
                Opt.of(conference).then(c -> c.conferenceId).or(""),
                Opt.of(conference).then(c -> c.conferenceAlias).or(""),
                new ParticipantNotification(
                        Opt.of(participant).then(c -> c.userId).or(""),
                        new ParticipantInfo(
                                Opt.of(participant).then(c -> c.externalName).or(""),
                                Opt.of(participant).then(c -> c.externalId).or(""),
                                Opt.of(participant).then(c -> c.externalAvatarUrl).or("")
                        ),
                        ConferenceParticipantStatus.LEFT
                ));
    }

    @NonNull
    @Override
    public String getType() {
        return EventNames.PARTICIPANT_LEFT_NOTIFICATION;
    }
}
