package com.voxeet.sdk.services.notification.internal;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.push.center.subscription.event.ConferenceCreatedNotificationEvent;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.Opt;

@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_CREATED_NOTIFICATION)
public class WebSocketConferenceCreated extends Event {

    @NonNull
    public EventConference conference;

    public ConferenceCreatedNotificationEvent to() {
        return new ConferenceCreatedNotificationEvent(
                Opt.of(conference).then(c -> c.conferenceId).or(""),
                Opt.of(conference).then(c -> c.conferenceAlias).or(""));
    }

    @NonNull
    @Override
    public String getType() {
        return EventNames.CONFERENCE_CREATED_NOTIFICATION;
    }
}
