package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.ThenVoid;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiOutConference;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import okhttp3.ResponseBody;
import retrofit2.Call;

public class UnsubscribeConferenceEventPromiseable extends AbstractPromiseable<Boolean, IRestApiOutConference> {

    private final String conferenceAlias;

    public UnsubscribeConferenceEventPromiseable(@NonNull ConferenceService parent,
                                                 @NonNull MediaDeviceService mediaDeviceService,
                                                 @NonNull IRestApiOutConference provider,
                                                 @Nullable String conferenceAlias,
                                                 @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, null, eventBus);
        this.conferenceAlias = conferenceAlias;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            String id = conferenceAlias;
            Call<ResponseBody> call = getApiRestCall().unSubscribe(id);

            HttpHelper.promise(call, ServerErrorOrigin.UNDEFINED)
                    .then((ThenVoid<HttpHelper.HttpAnswer<ResponseBody>>) answer -> solver.resolve(true))
                    .error(solver::reject);
        });
    }
}
