package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.android.media.MediaEngineException;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.StopScreenShareAnswerEvent;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiScreenShare;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import retrofit2.Call;

public class StopScreenSharePromise extends AbstractPromiseable<Boolean, IRestApiScreenShare> {
    private final static String TAG = StopScreenSharePromise.class.getSimpleName();

    public StopScreenSharePromise(@NonNull ConferenceService parent,
                                  @NonNull MediaDeviceService mediaDeviceService,
                                  @NonNull IRestApiScreenShare provider,
                                  @Nullable ConferenceInformation information,
                                  @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            final ConferenceInformation information = getInformation();
            MediaSDK media = getMedia();

            if (null == information || !getParent().isInConference()) {
                Log.d(TAG, "stopVideo: not in conf");

                if (null != media) media.stopVideo();
                Promise.reject(solver, new NotInConferenceException());
                return;
            }
            String conferenceId = information.getConference().getId();

            if (!isInConference()) {
                Log.d(TAG, "stopScreenShare: not in conf");

                if (null != media) media.stopScreenCapturer();
                Promise.reject(solver, new NotInConferenceException());
                return;
            }

            if (!hasMedia()) {
                Log.d(TAG, "stopScreenShare: media is null");
                Promise.reject(solver, new MediaEngineException("media is null"));
                return;
            }

            if (null != media) media.stopScreenCapturer();

            final Call<StopScreenSharingResponse> stopVideo = getApiRestCall().stopScreenShare(conferenceId);

            HttpHelper.promise(stopVideo, ServerErrorOrigin.STOP_RECORDING)
                    .then(answer -> {
                        StopScreenSharingResponse object = answer.object;
                        if (null != media) media.stopScreenCapturer();

                        information.setScreenShareOn(false);

                        final StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(true);
                        getEventBus().post(event);
                        solver.resolve(createVideoAnswer(object.participantId, object.description, object.candidates));
                    })
                    .error(error -> {
                        information.setScreenShareOn(false);

                        StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(false);
                        getEventBus().post(event);

                        solver.reject(error);
                    });
        });
    }
}
