package com.voxeet.sdk.services.conference.information;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ConferenceStatus model represents the following conference states:
 * - default (instantiated)
 * - creating
 * - created
 * - joining
 * - joined
 * - the first participant joined (different than the currently logged in participant)
 * - no more participants are in the conference
 * - leaving
 * - left
 *
 * The [isValid](/documentation/sdk/reference/android/models/conferencestatus#isvalid) method checks if the state is valid.
 */
@Annotate
public enum ConferenceStatus {
    DEFAULT(true),
    CREATING(true),
    CREATED(true),
    JOINING(true),
    JOINED(true),
    FIRST_PARTICIPANT(true),
    NO_MORE_PARTICIPANT(true),
    LEAVING(false),
    LEFT(false),
    ERROR(false),
    DESTROYED(false),
    ENDED(false);

    private final boolean mValid;

    @NoDocumentation
    ConferenceStatus(boolean valid) {
        mValid = valid;
    }

    /**
     * Checks if the current state is valid. It corresponds to the attended conference.
     *
     * @return a boolean indicating if a conference is possible in parallel to this state.
     */
    public boolean isValid() {
        return mValid;
    }
}
