package com.voxeet.sdk.network.endpoints;

import com.voxeet.sdk.push.center.subscription.register.BaseSubscription;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.HTTP;
import retrofit2.http.POST;

public interface IRestApiSubscribe {

    @POST("/v1/subscriptions")
    Call<ResponseBody> subscribe(@Body Subscriptions url);

    //@DELETE("/v1/subscriptions")
    @HTTP(method = "DELETE", path = "/v1/subscriptions", hasBody = true)
    Call<ResponseBody> unsubscribe(@Body Subscriptions url);

    public class Subscriptions {
        public List<BaseSubscription> subscriptions;

        private Subscriptions() {

        }

        public Subscriptions(List<BaseSubscription> subscriptions) {
            this();

            this.subscriptions = subscriptions;
        }
    }
}
