package com.voxeet.sdk.models.v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class File {

    @JsonProperty("filename")
    private String name;

    @JsonProperty("fileSize")
    private long size;

    @JsonProperty("fileType")
    private String type;

    private String owner;

    private String meetingId;

    private String fileId;

    private int nbImageConverted;

    @JsonProperty("fileUrl")
    private String url;

    @JsonProperty("fileThumbnailUrl")
    private String thumbnailUrl;

    private List<String> convertedImageUrls;

    private List<String> convertedImageThumbnailUrls;

    private long timestamp;

    private boolean converted;

    public String getName() {
        return null != name ? name : "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public int getNbImageConverted() {
        return nbImageConverted;
    }

    public void setNbImageConverted(int nbImageConverted) {
        this.nbImageConverted = nbImageConverted;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public List<String> getConvertedImageUrls() {
        List<String> images = new ArrayList<>();
        images.addAll(convertedImageUrls);
        return images;
    }

    public void setConvertedImageUrls(List<String> convertedImageUrls) {
        if (this.convertedImageUrls == null)
            this.convertedImageUrls = new ArrayList<>();
        else
            this.convertedImageUrls.clear();

        this.convertedImageUrls.addAll(convertedImageUrls);
    }

    public List<String> getConvertedImageThumbnailUrls() {
        List<String> thumbnails = new ArrayList<>();
        thumbnails.addAll(convertedImageThumbnailUrls);
        return thumbnails;
    }

    public void setConvertedImageThumbnailUrls(List<String> convertedImageThumbnailUrls) {
        if (this.convertedImageThumbnailUrls == null)
            this.convertedImageThumbnailUrls = new ArrayList<>();
        else
            this.convertedImageThumbnailUrls.clear();

        this.convertedImageThumbnailUrls.addAll(convertedImageThumbnailUrls);
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isConverted() {
        return converted;
    }

    public boolean isObjectValid() {
        return true;
    }

    public void setConverted(boolean converted) {
        this.converted = converted;
    }

    @Override
    public String toString() {
        return "File := " + getName() + " " + getFileId();
    }
}
