package com.voxeet.sdk.models.v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The CreateConferenceResult model keeps the results of a conference API call, such as the conference [ID](/documentation/sdk/reference/android/models/createconferenceresult#conferenceid) and [alias](/documentation/sdk/reference/android/models/createconferenceresult#conferencealias). It also checks if the conference [is new](/documentation/sdk/reference/android/models/createconferenceresult#isnew).
 */
@Annotate
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateConferenceResult {

    @NoDocumentation
    public CreateConferenceResult() {

    }

    /**
     * Keeps the conference ID generated by Voxeet servers.
     */
    public String conferenceId;

    /**
     * Keeps the conference alias if provided by developers.
     */
    public String conferenceAlias;

    /**
     * Indicates if a conference creation leads to a new conference or it already existed.
     */
    public boolean isNew;
}
