package com.voxeet.sdk.manifests;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public abstract class AbstractManifestComponentProvider extends ContentProvider {

    protected abstract void init(@NonNull Context context);

    protected abstract String getComponentName();

    protected abstract String getDefaultAuthority();

    @Override
    public boolean onCreate() {
        return true;
    }

    @Override
    public final void attachInfo(@NonNull Context context, @Nullable ProviderInfo info) {
        final String name = getClass().getName();
        if (info == null) {
            throw new NullPointerException(getComponentName() + " ProviderInfo cannot be null.");
        }

        String authority = info.authority;
        if (null == authority) authority = "";
        // So if the authorities equal the library internal ones, the developer forgot to set his applicationId
        if (authority.startsWith(getDefaultAuthority())) {
            throw new IllegalStateException("Incorrect authority provider. Please set into your AndroidManifest the following provider :\n"
                    + "    <application>\n" +
                    "        <provider\n" +
                    "            android:authorities=\"${applicationId}." + getComponentName() + "\"\n" +
                    "            android:name=\"" + name + "\"" +
                    "            android:enabled=\"true\"\n" +
                    "            android:exported=\"false\" />\n" +
                    "    </application>");
        } else {
            init(context);
        }

        super.attachInfo(context, info);
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }
}
