package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the specific video is resumed.
 */
@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.VIDEO_PRESENTATION_PLAY)
public class VideoPresentationPlay extends Event {

    /**
     * Represents the key of the current video.
     */
    public String key;

    /**
     * The conference ID.
     */
    public String conferenceId;

    /**
     * The creator of the request.
     */
    @JsonProperty("userId")
    public String participantId;

    /**
     * Represents the date.
     */
    public long timestamp;

    @NoDocumentation
    public VideoPresentationPlay() {

    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.VIDEO_PRESENTATION_PLAY;
    }
}
