package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;

@Annotate
@FromWebsocket
@InternalEvent
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_CONTACT_REMOVED)
public class OwnContactRemovedEvent extends Event {

    public String userId;

    public String contactId;

    @Override
    public String getType() {
        return EventNames.OWN_CONTACT_REMOVED;
    }
}
