package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.NoDocumentation;

@Annotate
@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_CONFERENCE_CREATED)
public class OwnConferenceCreated extends Event {

    public String participantId;

    @JsonProperty("conferenceInfo")
    public ConferenceInfos conferenceInfos;

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.OWN_CONFERENCE_CREATED;
    }
}
