package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when the conference has been ended.
 */
@Annotate
@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_ENDED)
public class ConferenceEnded extends Event {

    /**
     * The Conference id which triggered the event
     */
    @JsonProperty("conference_id")
    public String conferenceId;

    @NoDocumentation
    public ConferenceEnded() {

    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.CONFERENCE_ENDED;
    }
}
