package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when the conference has been destroyed.
 */
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_DESTROYED)
public class ConferenceDestroyedPush extends Event {

    /**
     * The Conference id which triggered the event
     */
    public String conferenceId;

    @NoDocumentation
    public String status;

    @NoDocumentation
    public ConferenceDestroyedPush() {

    }

    @NoDocumentation
    public ConferenceDestroyedPush(String conferenceId) {
        this.conferenceId = conferenceId;
        this.status = "";
    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.CONFERENCE_DESTROYED;
    }
}
