package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the message is broadcasted.
 */
@Annotate
@FromWebsocket
@JsonTypeName(EventNames.BROADCAST_EVENT)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BroadcastEvent extends Event {

    /**
     * The corresponding message.
     */
    @JsonProperty("message")
    public String message;

    /**
     * The ID of the participant who created the call.
     */
    @JsonProperty("from")
    public String participantId;

    @NoDocumentation
    public BroadcastEvent() {

    }

    @NoDocumentation
    public BroadcastEvent(String message) {
        this.message = message;
    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.BROADCAST_EVENT;
    }
}
