package com.voxeet.sdk.events.v2;

import android.support.annotation.NonNull;

import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.services.media.VideoState;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the local video state information has been changed.
 */
@Annotate
public class VideoStateEvent {

    @NoDocumentation
    @NonNull
    public Conference conference;

    /**
     * The new local video state.
     */
    @NonNull
    public VideoState videoState;

    @NoDocumentation
    public VideoStateEvent() {
    }

    @NoDocumentation
    public VideoStateEvent(@NonNull Conference conference, @NonNull VideoState videoState) {
        this.conference = conference;
        this.videoState = videoState;
    }
}
