package com.voxeet.sdk.events.v2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when a Status for a given RestParticipant has been changed in the Conference
 *
 * - join
 * - invited
 * - leaving
 * - left
 * - error
 * - etc...
 *
 * See the RestParticipant's Status for more information
 */
@Annotate
@FromSDK
public class ParticipantUpdatedEvent extends SuccessEvent {

    /**
     * The RestParticipant holding this event
     */
    @NonNull
    public Participant participant;

    /**
     * The underlying Conference instance
     */
    @NoDocumentation
    @Nullable
    public Conference conference;

    @NoDocumentation
    public ParticipantUpdatedEvent(@NonNull Conference conference,
                                   @NonNull Participant participant) {
        this.participant = participant;
        this.conference = conference;
    }
}
