package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Quality indicator for the current participant in the conference.
 */
@Annotate
@FromSDK
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.QUALITY_INDICATORS)
public class QualityIndicators extends SuccessEvent {

    /**
     * The current MoS for the current session in the conference
     */
    public float mos;

    @NoDocumentation
    public QualityIndicators(float mos) {
        super("");

        this.mos = mos;
    }

    @NonNull
    @Override
    public String getType() {
        return EventNames.QUALITY_INDICATORS;
    }
}
