package com.voxeet.sdk.events.sdk;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The MessageReceivedInWrongConference model represents the situation when the conference participant receives the message but not in the proper conference. This message includes the [sender ID](/documentation/sdk/reference/android/models/messagereceivedinwrongconference#participantid-string), [conference ID](/documentation/sdk/reference/android/models/messagereceivedinwrongconference#conferenceid-string), and its [content](/documentation/sdk/reference/android/models/messagereceivedinwrongconference#message-string).
 */
@FromSDK
@Annotate
public class MessageReceivedInWrongConference extends SuccessEvent {

    /**
     * The sender ID.
     */
    public String participantId;

    /**
     * The conference ID.
     */
    public String conferenceId;

    /**
     * The content of the corresponding message.
     */
    public String message;

    @NoDocumentation
    public MessageReceivedInWrongConference(String participantId, String conferenceId, String message) {
        this.participantId = participantId;
        this.conferenceId = conferenceId;
        this.message = message;
    }

}
