package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when an incoming call is received. This event is optional when the [NotificationService](/documentation/sdk/reference/android/notification) is properly referenced and set up on the developer side.
 */
@Annotate
@FromSDK
public class IncomingCallEvent {

    /**
     * The conference id from which the participant is being invited
     */
    public String conferenceId;

    @NoDocumentation
    public IncomingCallEvent(@NonNull String conferenceId) {

        this.conferenceId = conferenceId;
    }
}
