package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.voxeet.sdk.models.v1.HistoryConference;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.List;

/**
 * Emitted when the application asked about historical conference elements (by calling the history restful endpoint).
 */
@Annotate
public class ConferenceHistoryResult {

    /**
     * A list of events.
     */
    @NonNull
    public List<HistoryConference> items;

    @NoDocumentation
    public ConferenceHistoryResult(List<HistoryConference> response) {
        this.items = response;
    }

    @NoDocumentation
    public ConferenceHistoryResult() {

    }
}
