package com.voxeet.sdk.events.promises;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The NotInConferenceException model is an exception that is sent when there is a call that requires a connection with the conference that is not available.
 */
@Annotate
public class NotInConferenceException extends Throwable {

    @NoDocumentation
    public NotInConferenceException() {
        super("You are not in a conference");
    }
}
