package com.voxeet.sdk.utils;


import android.support.annotation.NonNull;

import com.voxeet.android.media.MediaStreamType;

public class PeerInformation {
    private final static MediaStreamType[] TYPES = new MediaStreamType[]{
            MediaStreamType.Camera,
            MediaStreamType.ScreenShare,
            MediaStreamType.Custom1,
            MediaStreamType.Custom2,
            MediaStreamType.Custom3,
            MediaStreamType.Custom4,
            MediaStreamType.Custom5,
            MediaStreamType.Custom6,
            MediaStreamType.Custom7,
            MediaStreamType.Custom8
    };

    public String index = "0";
    public String type = "camera";
    public String peerId;

    public MediaStreamType calculatedMediaStreamType;

    public PeerInformation(@NonNull String formatted, MediaStreamType originalCallbackOrigin) {
        String[] split = formatted.split("_");

        if (split.length == 3) {
            index = split[0];
            type = split[1];
            peerId = split[2];
            calculatedMediaStreamType = from(index);
        } else {
            index = Integer.toString(originalCallbackOrigin.ordinal());
            type = originalCallbackOrigin.name().toLowerCase();
            peerId = formatted;
            calculatedMediaStreamType = originalCallbackOrigin;
        }
    }

    @NonNull
    private MediaStreamType from(@NonNull String originalIndex) {
        int index = 0;
        try {
            index = Integer.parseInt(originalIndex);
        }catch (Exception e){
            e.printStackTrace();
        }

        if(index >= 0 && index < TYPES.length) return TYPES[index];
        return TYPES[0];
    }
}