package com.voxeet.sdk.services.simulcast;

import com.google.gson.annotations.SerializedName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Represent the specified stream quality expected.
 *
 * it can be represented by the following values :
 * - HD _High Definition_
 * - MD _Medium Definition_
 * - SD _Standard Definition_
 */
@Annotate
public enum Quality {
    @SerializedName("HD")
    HD,
    @SerializedName("MD")
    MD,
    @SerializedName("SD")
    SD;

    @NoDocumentation
    @Override
    public String toString() {
        //hd, md, sd
        return name();
    }
}
