package com.voxeet.sdk.services.simulcast;

import android.support.annotation.NonNull;
import android.util.Log;

import com.voxeet.sdk.utils.Annotate;

/**
 * Expected video quality for a specified participant in a conference
 */
@Annotate
public class ParticipantQuality {
    public final static String ALL = "*";

    /**
     * Participant's ID.
     */
    public final String id;

    /**
     * Expected Participant's video quality
     */
    public final Quality quality;

    /**
     * Create an holder to set the quality for each and every participants in a conference at the time the simulcast method will be resolved.
     * @param quality quality expected for all participants in the conference that are not set in the same call
     */
    public ParticipantQuality(@NonNull Quality quality) {
        this(ALL, quality);
    }

    /**
     * Create an holder to set the quality for the specified tuple of participant and expected video stream quality at the time the simulcast method will be resolved.
     * @param id participant's ID
     * @param quality quality expected for the specified participant
     */
    public ParticipantQuality(@NonNull String id, @NonNull Quality quality) {
        Log.d("ParticipantQuality", "create for " + id + " " + quality);
        this.id = id;
        this.quality = quality;
    }
}
