package com.voxeet.sdk.services.notification;

import android.support.annotation.Nullable;

import com.voxeet.sdk.utils.Annotate;

/**
 * The NotificationTokenHolderFactory model is responsible for implementing notifications. The SDK or a developer sets a provider to manage information related to push notifications.
 *
 *  To use it, use the following UXKit module:
 * `compile "com.voxeet.sdk:toolkit-firebase:0.0.2"`
 *
 * Then, customize the development implementation, as in this example:
 * ```
 * INotificationTokenProvider provider = new MyOwnFirebaseTokenProvider();
 * NotificationTokenHolderFactory.provider = provider;
 * ```
 *
 * Note: Use it before logging in the participant. Preferrably in a `ComponentProvider` or on an Application level.
 */
@Annotate
public class NotificationTokenHolderFactory {

    /**
     * Hold the instance (or null if invalid) of the Firebase token provider
     */
    @Nullable
    public static INotificationTokenProvider provider;

    private NotificationTokenHolderFactory() {

    }
}
