package com.voxeet.sdk.services.holder;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.services.VoxeetHttp;
import com.voxeet.sdk.utils.Opt;

import org.greenrobot.eventbus.EventBus;

public class ServiceProviderHolder<RETROFIT_SERVICE_KLASS> {
    public final static ServiceProviderHolder DEFAULT = new ServiceProviderHolder();

    @Nullable
    protected VoxeetHttp client;

    @NonNull
    protected EventBus eventBus;

    @Nullable
    private Class<RETROFIT_SERVICE_KLASS> service;

    private ServiceProviderHolder() {
        eventBus = EventBus.getDefault();
    }

    private ServiceProviderHolder(@Nullable VoxeetHttp client,
                                  @NonNull EventBus eventBus,
                                  @Nullable Class<RETROFIT_SERVICE_KLASS> service) {
        this.client = client;
        this.eventBus = eventBus;
        this.service = service;
    }

    @NonNull
    public EventBus getEventBus() {
        return eventBus;
    }

    @Nullable
    public RETROFIT_SERVICE_KLASS getService() {
        return Opt.of(client).then(s -> s.get(service)).orNull();
    }

    @Nullable
    public <TYPE> TYPE getService(Class<TYPE> klass) {
        return Opt.of(client).then(s -> s.get(klass)).orNull();
    }

    public static class Builder<RETROFIT_SERVICE_KLASS> {
        @Nullable
        private VoxeetHttp client;
        @NonNull
        private EventBus eventBus;
        @Nullable
        private Class<RETROFIT_SERVICE_KLASS> service;

        public Builder() {
            eventBus = EventBus.getDefault();
        }

        public Builder<RETROFIT_SERVICE_KLASS> setClient(@Nullable VoxeetHttp client) {
            this.client = client;
            return this;
        }

        public Builder<RETROFIT_SERVICE_KLASS> setEventBus(@NonNull EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Builder<RETROFIT_SERVICE_KLASS> setService(@Nullable Class<RETROFIT_SERVICE_KLASS> service) {
            this.service = service;
            return this;
        }

        public ServiceProviderHolder<RETROFIT_SERVICE_KLASS> build() {
            return new ServiceProviderHolder<>(
                    client,
                    eventBus,
                    service
            );
        }

    }

}
