package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiSimulcast;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.simulcast.ParticipantQuality;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import retrofit2.Call;
import retrofit2.Response;

public class SimulcastPromiseable extends AbstractPromiseable<Boolean, IRestApiSimulcast> {

    private final String conferenceId;
    private List<ParticipantQuality> requested = null;

    public SimulcastPromiseable(@NonNull ConferenceService parent,
                                @NonNull MediaDeviceService mediaDeviceService,
                                @NonNull IRestApiSimulcast provider,
                                @Nullable ConferenceInformation information,
                                @NonNull EventBus eventBus,
                                @Nullable List<ParticipantQuality> requested) {
        super(parent, mediaDeviceService, provider, information, eventBus);

        this.conferenceId = Opt.of(information).then(ConferenceInformation::getConference).then(Conference::getId).or("");
        this.requested = requested;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            Call<Boolean> observable = getApiRestCall().simulcast(conferenceId, new IRestApiSimulcast.ParticipantExpectedQualityBody(requested));
            HttpHelper.promise(observable, ServerErrorOrigin.SIMULCAST)
                    .then(answer -> {
                        int code = Opt.of(answer).then(a -> a.response).then(Response::code).or(400);

                        solver.resolve(code >= 200 && code < 300);
                    }).error(solver::reject);
        });

    }
}
