package com.voxeet.sdk.network.endpoints;

import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.models.v1.HistoryConference;
import com.voxeet.sdk.models.v1.SubscribeConference;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Path;

public interface IRestApiOutConference {
    @GET("/v1/conferences/{id}/status")
    Call<ConferenceStatusResult> conferenceStatus(@Path("id") String conferenceId);

    @DELETE("/v1/conferences/{id}/subscribe")
    Call<ResponseBody> unSubscribe(@Path("id") String conferenceId);

    @GET("/v1/conferences/{id}/subscribe")
    Call<SubscribeConference> subscribe(@Path("id") String conferenceId);

    @GET("/v1/conferences/{id}/history")
    Call<List<HistoryConference>> conferenceHistory(@Path("id") String conferenceId);

    @GET("v1/conferences/{id}/call/subscribe")
    Call<ResponseBody> subscribeForCall(@Path("id") String conferenceId);

    @DELETE("v1/conferences/{id}/call/subscribe")
    Call<ResponseBody> unsubscribeFromCall(@Path("id") String conferenceId);

}
