package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.VoxeetSDK;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;

@Annotate
@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_PRESENTATION_STARTED)
public class FilePresentationStarted extends Event {

    public String conferenceId;

    public String userId;

    public int imageCount;

    public String fileId;

    public int position;

    public boolean isOwner() {
        SessionService service = VoxeetSDK.session();

        return null != userId && null != service && userId.equals(service.getParticipantId());
    }

    @Override
    public String getType() {
        return EventNames.FILE_PRESENTATION_STARTED;
    }
}
